/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.container;

import cofh.lib.gui.container.ContainerBase;
import cofh.lib.gui.container.InventoryContainerItemWrapper;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class ContainerInventoryItem
extends ContainerBase {
    protected final InventoryContainerItemWrapper containerWrapper;
    protected final EntityPlayer player;
    protected final int containerIndex;
    protected boolean valid = true;

    public ContainerInventoryItem(ItemStack itemStack, InventoryPlayer inventoryPlayer) {
        this.player = inventoryPlayer.player;
        this.containerIndex = inventoryPlayer.currentItem;
        this.containerWrapper = new InventoryContainerItemWrapper(itemStack);
    }

    @Override
    protected int getSizeInventory() {
        return this.containerWrapper.getSizeInventory();
    }

    public ItemStack getContainerStack() {
        return this.containerWrapper.getContainerStack();
    }

    public String getInventoryName() {
        return this.containerWrapper.getInventoryName();
    }

    public void detectAndSendChanges() {
        ItemStack itemStack = this.player.inventory.mainInventory[this.containerIndex];
        if (itemStack == null || itemStack.getItem() != this.containerWrapper.getContainerItem()) {
            this.valid = false;
            return;
        }
        super.detectAndSendChanges();
    }

    public void onSlotChanged() {
        ItemStack itemStack = this.player.inventory.mainInventory[this.containerIndex];
        if (this.valid && itemStack != null && itemStack.getItem() == this.containerWrapper.getContainerItem()) {
            this.player.inventory.mainInventory[this.containerIndex] = this.containerWrapper.getContainerStack();
        }
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        this.onSlotChanged();
        if (this.containerWrapper.getDirty() && !this.valid) {
            entityPlayer.inventory.setItemStack(null);
        }
        return this.valid;
    }

    @Override
    protected boolean performMerge(int n, ItemStack itemStack) {
        int n2 = 27;
        int n3 = n2 + 9;
        int n4 = n3 + this.getSizeInventory();
        if (n < n3) {
            return this.mergeItemStack(itemStack, n3, n4, false);
        }
        return this.mergeItemStack(itemStack, 0, n3, true);
    }

    @Override
    public ItemStack slotClick(int n, int n2, int n3, EntityPlayer entityPlayer) {
        if (n3 == 2 && n2 == this.containerIndex) {
            return null;
        }
        ItemStack itemStack = null;
        InventoryPlayer inventoryPlayer = entityPlayer.inventory;
        if (n3 == 5) {
            int n4 = this.field_94536_g;
            this.field_94536_g = ContainerInventoryItem.func_94532_c((int)n2);
            if ((n4 != 1 || this.field_94536_g != 2) && n4 != this.field_94536_g) {
                this.func_94533_d();
            } else if (inventoryPlayer.getItemStack() == null) {
                this.func_94533_d();
            } else if (this.field_94536_g == 0) {
                this.field_94535_f = ContainerInventoryItem.func_94529_b((int)n2);
                if (ContainerInventoryItem.func_94528_d((int)this.field_94535_f)) {
                    this.field_94536_g = 1;
                    this.field_94537_h.clear();
                } else {
                    this.func_94533_d();
                }
            } else if (this.field_94536_g == 1) {
                Slot slot = (Slot)this.inventorySlots.get(n);
                if (slot != null && ContainerInventoryItem.func_94527_a((Slot)slot, (ItemStack)inventoryPlayer.getItemStack(), (boolean)true) && slot.isItemValid(inventoryPlayer.getItemStack()) && inventoryPlayer.getItemStack().stackSize > this.field_94537_h.size() && this.canDragIntoSlot(slot)) {
                    this.field_94537_h.add(slot);
                }
            } else if (this.field_94536_g == 2) {
                if (!this.field_94537_h.isEmpty()) {
                    ItemStack itemStack2 = inventoryPlayer.getItemStack().copy();
                    int n5 = inventoryPlayer.getItemStack().stackSize;
                    for (Slot slot : this.field_94537_h) {
                        if (slot == null || !ContainerInventoryItem.func_94527_a((Slot)slot, (ItemStack)inventoryPlayer.getItemStack(), (boolean)true) || !slot.isItemValid(inventoryPlayer.getItemStack()) || inventoryPlayer.getItemStack().stackSize < this.field_94537_h.size() || !this.canDragIntoSlot(slot)) continue;
                        ItemStack itemStack3 = itemStack2.copy();
                        int n6 = slot.getHasStack() ? slot.getStack().stackSize : 0;
                        ContainerInventoryItem.func_94525_a((Set)this.field_94537_h, (int)this.field_94535_f, (ItemStack)itemStack3, (int)n6);
                        if (itemStack3.stackSize > itemStack3.getMaxStackSize()) {
                            itemStack3.stackSize = itemStack3.getMaxStackSize();
                        }
                        if (itemStack3.stackSize > slot.getSlotStackLimit()) {
                            itemStack3.stackSize = slot.getSlotStackLimit();
                        }
                        n5 -= itemStack3.stackSize - n6;
                        slot.putStack(itemStack3);
                    }
                    itemStack2.stackSize = n5;
                    if (itemStack2.stackSize <= 0) {
                        itemStack2 = null;
                    }
                    inventoryPlayer.setItemStack(itemStack2);
                }
                this.func_94533_d();
            } else {
                this.func_94533_d();
            }
        } else if (this.field_94536_g != 0) {
            this.func_94533_d();
        } else if (!(n3 != 0 && n3 != 1 || n2 != 0 && n2 != 1)) {
            if (n == -999) {
                if (inventoryPlayer.getItemStack() != null && n == -999) {
                    if (n2 == 0) {
                        entityPlayer.dropPlayerItemWithRandomChoice(inventoryPlayer.getItemStack(), true);
                        inventoryPlayer.setItemStack((ItemStack)null);
                    }
                    if (n2 == 1) {
                        entityPlayer.dropPlayerItemWithRandomChoice(inventoryPlayer.getItemStack().splitStack(1), true);
                        if (inventoryPlayer.getItemStack().stackSize == 0) {
                            inventoryPlayer.setItemStack((ItemStack)null);
                        }
                    }
                }
            } else if (n3 == 1) {
                ItemStack itemStack4;
                if (n < 0) {
                    return null;
                }
                Slot slot = (Slot)this.inventorySlots.get(n);
                if (slot != null && slot.canTakeStack(entityPlayer) && (itemStack4 = this.transferStackInSlot(entityPlayer, n)) != null) {
                    Item item = itemStack4.getItem();
                    itemStack = itemStack4.copy();
                    if (slot.getStack() != null && slot.getStack().getItem() == item) {
                        this.retrySlotClick(n, n2, true, entityPlayer);
                    }
                }
            } else {
                if (n < 0) {
                    return null;
                }
                Slot slot = (Slot)this.inventorySlots.get(n);
                if (slot != null) {
                    ItemStack itemStack5 = slot.getStack();
                    ItemStack itemStack6 = inventoryPlayer.getItemStack();
                    if (itemStack5 != null) {
                        itemStack = itemStack5.copy();
                    }
                    if (itemStack5 == null) {
                        if (itemStack6 != null && slot.isItemValid(itemStack6)) {
                            int n7;
                            int n8 = n7 = n2 == 0 ? itemStack6.stackSize : 1;
                            if (n7 > slot.getSlotStackLimit()) {
                                n7 = slot.getSlotStackLimit();
                            }
                            if (itemStack6.stackSize >= n7) {
                                slot.putStack(itemStack6.splitStack(n7));
                            }
                            if (itemStack6.stackSize == 0) {
                                inventoryPlayer.setItemStack((ItemStack)null);
                            }
                        }
                    } else if (slot.canTakeStack(entityPlayer)) {
                        int n9;
                        if (itemStack6 == null) {
                            int n10 = n2 == 0 ? itemStack5.stackSize : (itemStack5.stackSize + 1) / 2;
                            ItemStack itemStack7 = slot.decrStackSize(n10);
                            inventoryPlayer.setItemStack(itemStack7);
                            if (itemStack5.stackSize == 0) {
                                slot.putStack((ItemStack)null);
                            }
                            slot.onPickupFromSlot(entityPlayer, inventoryPlayer.getItemStack());
                        } else if (slot.isItemValid(itemStack6)) {
                            if (itemStack5.getItem() == itemStack6.getItem() && itemStack5.getItemDamage() == itemStack6.getItemDamage() && ItemStack.areItemStackTagsEqual((ItemStack)itemStack5, (ItemStack)itemStack6)) {
                                int n11;
                                int n12 = n11 = n2 == 0 ? itemStack6.stackSize : 1;
                                if (n11 > slot.getSlotStackLimit() - itemStack5.stackSize) {
                                    n11 = slot.getSlotStackLimit() - itemStack5.stackSize;
                                }
                                if (n11 > itemStack6.getMaxStackSize() - itemStack5.stackSize) {
                                    n11 = itemStack6.getMaxStackSize() - itemStack5.stackSize;
                                }
                                itemStack6.splitStack(n11);
                                if (itemStack6.stackSize == 0) {
                                    inventoryPlayer.setItemStack((ItemStack)null);
                                }
                                itemStack5.stackSize += n11;
                                slot.putStack(itemStack5);
                            } else if (itemStack6.stackSize <= slot.getSlotStackLimit()) {
                                slot.putStack(itemStack6);
                                inventoryPlayer.setItemStack(itemStack5);
                            }
                        } else if (itemStack5.getItem() == itemStack6.getItem() && itemStack6.getMaxStackSize() > 1 && (!itemStack5.getHasSubtypes() || itemStack5.getItemDamage() == itemStack6.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)itemStack5, (ItemStack)itemStack6) && (n9 = itemStack5.stackSize) > 0 && n9 + itemStack6.stackSize <= itemStack6.getMaxStackSize()) {
                            itemStack6.stackSize += n9;
                            itemStack5 = slot.decrStackSize(n9);
                            if (itemStack5.stackSize == 0) {
                                slot.putStack((ItemStack)null);
                            }
                            slot.onPickupFromSlot(entityPlayer, inventoryPlayer.getItemStack());
                        }
                    }
                    slot.onSlotChanged();
                }
            }
        } else if (n3 == 2 && n2 >= 0 && n2 < 9) {
            Slot slot = (Slot)this.inventorySlots.get(n);
            if (slot.canTakeStack(entityPlayer)) {
                ItemStack itemStack8 = inventoryPlayer.getStackInSlot(n2);
                boolean bl = itemStack8 == null || slot.inventory == inventoryPlayer && slot.isItemValid(itemStack8);
                int n13 = -1;
                if (!bl) {
                    n13 = inventoryPlayer.getFirstEmptyStack();
                    bl |= n13 > -1;
                }
                if (slot.getHasStack() && bl) {
                    ItemStack itemStack9 = slot.getStack();
                    inventoryPlayer.setInventorySlotContents(n2, itemStack9.copy());
                    if (!(slot.inventory == inventoryPlayer && slot.isItemValid(itemStack8) || itemStack8 == null)) {
                        if (n13 > -1) {
                            inventoryPlayer.addItemStackToInventory(itemStack8);
                            slot.decrStackSize(itemStack9.stackSize);
                            slot.putStack((ItemStack)null);
                            slot.onPickupFromSlot(entityPlayer, itemStack9);
                        }
                    } else {
                        slot.decrStackSize(itemStack9.stackSize);
                        slot.putStack(itemStack8);
                        slot.onPickupFromSlot(entityPlayer, itemStack9);
                    }
                } else if (!slot.getHasStack() && itemStack8 != null && slot.isItemValid(itemStack8)) {
                    inventoryPlayer.setInventorySlotContents(n2, (ItemStack)null);
                    slot.putStack(itemStack8);
                }
            }
        } else if (n3 == 3 && entityPlayer.capabilities.isCreativeMode && inventoryPlayer.getItemStack() == null && n >= 0) {
            Slot slot = (Slot)this.inventorySlots.get(n);
            if (slot != null && slot.getHasStack()) {
                ItemStack itemStack10 = slot.getStack().copy();
                itemStack10.stackSize = itemStack10.getMaxStackSize();
                inventoryPlayer.setItemStack(itemStack10);
            }
        } else if (n3 == 4 && inventoryPlayer.getItemStack() == null && n >= 0) {
            Slot slot = (Slot)this.inventorySlots.get(n);
            if (slot != null && slot.getHasStack() && slot.canTakeStack(entityPlayer)) {
                ItemStack itemStack11 = slot.decrStackSize(n2 == 0 ? 1 : slot.getStack().stackSize);
                slot.onPickupFromSlot(entityPlayer, itemStack11);
                entityPlayer.dropPlayerItemWithRandomChoice(itemStack11, true);
            }
        } else if (n3 == 6 && n >= 0) {
            Slot slot = (Slot)this.inventorySlots.get(n);
            ItemStack itemStack12 = inventoryPlayer.getItemStack();
            if (!(itemStack12 == null || slot != null && slot.getHasStack() && slot.canTakeStack(entityPlayer))) {
                int n14 = n2 == 0 ? 0 : this.inventorySlots.size() - 1;
                int n15 = n2 == 0 ? 1 : -1;
                for (int i = 0; i < 2; ++i) {
                    for (int j = n14; j >= 0 && j < this.inventorySlots.size() && itemStack12.stackSize < itemStack12.getMaxStackSize(); j += n15) {
                        Slot slot2 = (Slot)this.inventorySlots.get(j);
                        if (!slot2.getHasStack() || !ContainerInventoryItem.func_94527_a((Slot)slot2, (ItemStack)itemStack12, (boolean)true) || !slot2.canTakeStack(entityPlayer) || !this.func_94530_a(itemStack12, slot2) || i == 0 && slot2.getStack().stackSize == slot2.getStack().getMaxStackSize()) continue;
                        int n16 = Math.min(itemStack12.getMaxStackSize() - itemStack12.stackSize, slot2.getStack().stackSize);
                        ItemStack itemStack13 = slot2.decrStackSize(n16);
                        itemStack12.stackSize += n16;
                        if (itemStack13.stackSize <= 0) {
                            slot2.putStack((ItemStack)null);
                        }
                        slot2.onPickupFromSlot(entityPlayer, itemStack13);
                    }
                }
            }
            this.detectAndSendChanges();
        }
        return itemStack;
    }
}

